#Paso 6
library(forecast)
library(nortest)
serie1 <- ts(Datos[,3:6], frequency = 12, start = c(1997, 10))
print( serie1, calendar = TRUE)
plot(serie1[,1])

#Paso 7
plot(serie1)

#Autocorrelacin
#Paso 8.1
acf(serie1[,1], na.action=na.pass)  

#Paso 8.2
pacf(serie1[,1], na.action=na.pass)

#Paso 8.3
tsdisplay(serie1[,1])

#Paso 9. Serie estacionaria o no estacionaria
ndiffs(serie1[,1])

#Paso 10. Construccin de un modelo Arima mediante un modelizador experto
t1 <- auto.arima(serie1[,1],stepwise=TRUE)
t1

#Paso 11. Prediccin de valores futuros del modelo Arima mediante modelizador experto
forecast(t1, h=20,level=c(95))
plot(forecast(t1, h=20,level=c(95)), shaded = FALSE)
lines(serie1[,1]-t1$residuals, col = "blue")

#Diagnsticos del modelo Arima mediante modelizador experto
#Paso 12.1
plot(residuals(t1))

#Paso 12.2
tsdiag(t1)

#Paso 12.3
Box.test(t1$resid, 12, type="Ljung")

#Paso 12.4
qqnorm(t1$resid)
Shapiro<-shapiro.test(residuals(t1))
Shapiro
Lillie<-lillie.test(residuals(t1))
Lillie

#Desestacionalizacin
#Paso 13.1
seasonplot(serie1[,1])

#Paso 13.2
s3 <- na.approx(serie1[,1])
plot(seasadj(decompose(s3,"multiplicative")))

#Paso 14. Construccin de un modelo Arima previamente especificado
t1 <- arima(serie1[,1], order = c(1,0,0), seasonal = list(order=c(1,1,0)))
t1
plot(forecast(t1, h=20), plot.conf = FALSE)

#Diagnsticos del modelo Arima previamente especificado
#Paso 15.1
plot(residuals(t1))

#Paso 15.2
tsdiag(t1)

#Paso 15.3
Box.test(t1$resid, 12, type="Ljung")

#Paso 15.4
qqnorm(t1$resid)
Shapiro<-shapiro.test(residuals(t1))
Shapiro
Lillie<-lillie.test(residuals(t1))
Lillie

#Paso 16. Introduccin de covariables
t1 <- arima(serie1[,1], order = c(2,0,0), seasonal = list(order=c(2,0,0)), xreg =serie1[,2:4])
t1


